﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja o warunkach zatrudnienia</title>
		<script runat="server">

	static readonly string dots = ". . . . . . . . . .";

    public class _Info : ContextBase {
        public _Info(Context context) : base(context) {
        }

        int iloscKopii = 1;
        [Caption("Ilość kopii")]
        [Priority(10)]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    _Info info;
    [Context]
    public _Info Info {
        set { info = value; }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
		            
    void dc_ContextLoad(Object sender, EventArgs e) {
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
        ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(ph);

        Date today = ((ActualDate)dc[typeof(ActualDate)]).Actual;
		FromTo year = FromTo.Year(today.Year);
		
        KalendModule kalend = KalendModule.GetInstance(dc);

        dlNocneLimit.EditValue = ph.Etat.Kalendarz.Nocne.Limit;
        dlNocneOd.EditValue = ph.Etat.Kalendarz.Nocne.Od;
        Time nocneDo = ph.Etat.Kalendarz.Nocne.Do;
        if (nocneDo>Time.Midnight)
			nocneDo -= Time.Midnight;
        dlNocneDo.EditValue = nocneDo;

        Time limitG = Time.Zero;
        Time limitGU = Time.Zero;
        decimal limitDP = 0;
        decimal limitDPU = 0;
        decimal limitD = 0;
        DefinicjaLimitu definicja = kalend.DefinicjeLimitow.UrlopWypoczynkowy;
		IEnumerable limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][year];
        FromTo okresLimit = ph.Etat.OkresZatrudnienia * year;
        int limitbazowy = 0;
        Date dataZmiany = Date.Empty;
        foreach (LimitNieobecnosci l in limity) {
            LimitUrlopuWypoczynkowego lu = l as LimitUrlopuWypoczynkowego;
            if (lu != null && okresLimit.IsIntersected(lu.Okres)) {
                if (dataZmiany == Date.Empty && (limitbazowy == 0 || limitbazowy == lu.Limit)) {
                    limitbazowy = lu.Limit;
                    limitG += lu.LimitGodz + lu.ZmianaGodz;

                            if (ph.Etat.NormaDobowa != Time.Zero)
                                limitDP += lu.PodstawaGodz - (decimal)(lu.WykorzystanyPoprzGodz / ph.Etat.NormaDobowa);
                            else
                                limitDP += lu.PodstawaGodz;

                            if (ph.Etat.NormaDobowa != Time.Zero)
                                limitDP += (decimal)(lu.ZmianaGodz / ph.Etat.NormaDobowa);
                }
                else {
                    if (dataZmiany == Date.Empty) {
                        dataZmiany = lu.Okres.From;
                    }
                    limitGU += lu.LimitGodz + lu.ZmianaGodz;
                    limitDPU += lu.PodstawaGodz;
                    if (ph.Etat.NormaDobowa != Time.Zero)
                        limitDPU += (decimal)(lu.ZmianaGodz / ph.Etat.NormaDobowa);
                }
                limitD = lu.Limit;
            }
        }

        if (dataZmiany == Date.Empty) {
            sectionUrlop.Visible = true;
            sectionUzupełniający.Visible = false;
            if (limitG == Time.Zero)
                dlGodzProp.EditValue = dots;
            else
                dlGodzProp.EditValue = limitG;
            if (limitDP == 0)
                dlLimitProp.EditValue = dots;
            else
                dlLimitProp.EditValue = limitDP;
            if (limitD == 0)
                dlLimit.EditValue = dots;
            else
                dlLimit.EditValue = limitD;
        }
        else {
            sectionUrlop.Visible = false;
            sectionUzupełniający.Visible = true;
            dlDataUzup.EditValue = dataZmiany;

            if (limitG == Time.Zero)
                dlGodzPropBase.EditValue = dots;
            else
                dlGodzPropBase.EditValue = limitG;
            if (limitDP == 0)
                dlLimitPropBase.EditValue = dots;
            else
                dlLimitPropBase.EditValue = limitDP;
            if (limitbazowy == 0)
                dlLimitBase.EditValue = dots;
            else
                dlLimitBase.EditValue = limitbazowy;
                        
            if (limitGU == Time.Zero)
                dlGodzPropUzup.EditValue = dots;
            else
                dlGodzPropUzup.EditValue = limitGU;
            
            if (limitDPU == 0)
                dlLimitPropUzup.EditValue = dots;
            else
                dlLimitPropUzup.EditValue = limitDPU;                                    
            if (limitD-limitbazowy  == 0)
                dlLimitUzup.EditValue = dots;
            else
                dlLimitUzup.EditValue = limitD - limitbazowy;
        }        

        Time limitGD = Time.Zero;
        decimal limitDPD = 0;
        decimal limitDD = 0;
        definicja = kalend.DefinicjeLimitow.UrlopDodatkowy;
        limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][year];
        okresLimit = ph.Etat.OkresZatrudnienia * year;
        foreach (LimitNieobecnosci l in limity) {
            LimitUrlopuWypoczynkowego lu = l as LimitUrlopuWypoczynkowego;
            if (lu != null && okresLimit.IsIntersected(lu.Okres)) {
                limitGD += lu.LimitGodz + lu.ZmianaGodz;
                limitDPD += lu.PodstawaGodz;
                if (ph.Etat.NormaDobowa != Time.Zero)
                    limitDPD += (decimal)(lu.ZmianaGodz / ph.Etat.NormaDobowa);
                limitDD = lu.Limit;
            }
        }
        if (limitGD == Time.Zero)
            dlGodzPropDod.EditValue = dots;
        else
            dlGodzPropDod.EditValue = limitGD;
        if (limitDPD == 0)
            dlLimitPropDod.EditValue = dots;
        else
            dlLimitPropDod.EditValue = limitDPD;
        if (limitDD == 0)
            dlLimitDod.EditValue = dots;
        else
            dlLimitDod.EditValue = limitDD;
        Section2.Visible = (limitDD > 0);
        
        /*
		int t = ph.Etat.OkresWypowiedzenia.Tygodnie;
		int m = ph.Etat.OkresWypowiedzenia.Miesiace;
        int d = 0;
		if (t==0 && m==0)
            if (ph.Etat.TypUmowy == TypUmowyOPrace.NaOkresPróbny) {
                FromTo st = ph.Etat.Okres;
                StazPracy staz = new StazPracy(st, ph).Normalizuj();
                int sd = st.To - st.From + 1;
                if (staz.Lata > 0 || staz.Miesiace >= 3)
                    t = 2;
                else if (sd >= 14)
                    t = 1;
                else
                    d = 3;
                
            }
            else if (ph.Etat.TypUmowy == TypUmowyOPrace.NaCzasOkreślony) {
                FromTo oz = ph.Etat.Okres;
                StazPracy sp = new StazPracy(oz, ph).Normalizuj();
                if (sp.Lata > 0 || sp.Miesiace > 6 || sp.Miesiace==6 && sp.Dni>0)
                    t = 2;
            }
            else if (ph.Etat.TypUmowy != TypUmowyOPrace.NaCzasNieokreślony) {
                t = 2;
            }
            else {
                Date od = ph.Etat.OkresZatrudnienia.From;

                if (od > Date.MinValue && od <= today) {
                    FromTo st = new FromTo(od, today);
                    StazPracy staz = new StazPracy(st, ph).Normalizuj();
                    if (staz.Lata >= 3)
                        m = 3;
                    else if (staz.Lata >= 1 || staz.Miesiace >= 6)
                        m = 1;
                    else
                        t = 2;
                }
            }

        if (ph.Etat.TypUmowy == TypUmowyOPrace.NaCzasNieokreślony)
            dlWypowiedzenie.EditValue = "jest zgodny ze wskazanym w art. 36 § 1 k.p";
        else {
            string str = "";
            if (d > 0)
			    switch (d) {
				    case 1:
					    str = "1 dzień"; break;
				    default:
					    str = d + " dni"; break;
			    }
            else if (t>0)        
			    switch (t) {
				    case 1:
					    str = "1 tydzień"; break;
				    default:
					    str = t + " tygodnie"; break;
			    }
		    else if (m>0)
			    switch (m) {
				    case 1:
					    str = "1 miesiąc"; break;
				    case 2:
				    case 3:
				    case 4:
					    str = m + " miesiące"; break;
				    default:
					    str = t + " miesięcy"; break;
			    }
            else
                str = " nie dotyczy";
            dlWypowiedzenie.EditValue = string.Format("wynosi <strong>{0}</strong>", str);
        }
        */
        if (ph.Etat.TypUmowy == TypUmowyOPrace.NaOkresPróbny)
            dlWypowiedzenie.EditValue = "jest zgodny ze wskazanym w art. 34 k.p";
        else
            dlWypowiedzenie.EditValue = "jest zgodny ze wskazanym w art. 36 § 1 k.p";

        Section1.Visible = ph.Etat.ZbiorowyUkladPracy;
        
        Date dataUkładu = ph.Module.Config.Ogólne.ZbiorowyUkładPracy;

        dlUkładZbiorowy.EditValue = dataUkładu == Date.Empty ? dots : dataUkładu.ToString();

        labelStanowisko.EditValue = GetStanowisko(ph);
        
        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(ph);
        DataRepeater1.DataSource = al;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
            
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZaświadczenieOZatrudnieniu" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" OnContextLoad="dc_ContextLoad"></ea:datacontext>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
            <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
                ResetPageCounter="True"></ea:PageBreak>
			<P><cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Informacja o warunkach zatrudnienia i uprawnieniach pracowniczych|%MIEJSCOWOSC%, {0}"
					runat="server" DataMember0="Context.ActualDate.Actual"></cc1:reportheader></P>
            <font face="Tahoma" size="2">
            <p style="text-align:justify">
			<P><ea:datalabel id="DataLabel8" runat="server" Bold="False" DataMember="Plec">
					<ValuesMap>
						<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
						<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
					</ValuesMap>
				</ea:datalabel>:
				<ea:datalabel id="DataLabel1" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:datalabel><BR>
				Stanowisko:
				<ea:datalabel id="labelStanowisko" runat="server"></ea:datalabel></P>
			<OL>
				<LI>
					Dobowa i tygodniowa norma czasu pracy
					<BR>
					– dobowa norma:
					<ea:datalabel id="DataLabel2" runat="server" DataMember="Etat.NormaDobowa"></ea:datalabel>&nbsp;godzin<BR>
					– tygodniowa norma:
					<ea:datalabel id="DataLabel3" runat="server" DataMember="Etat.NormaTygodniowa"></ea:datalabel>&nbsp;godzin<BR>
					w okresie rozliczeniowym wynoszącym
					<ea:datalabel id="DataLabel4" runat="server" DataMember="Etat.Kalendarz.Nadgodziny.Okres"></ea:datalabel>&nbsp;<ea:datalabel id="DataLabel5" runat="server" Bold="False" DataMember="Etat.Kalendarz.Nadgodziny.Okres">
						<ValuesMap>
							<ea:ValuesPair Key="1" Value="miesiąc"></ea:ValuesPair>
							<ea:ValuesPair Key="10" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="11" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="12" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="2" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="3" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="4" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="5" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="6" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="7" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="8" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="9" Value="miesięcy"></ea:ValuesPair>
						</ValuesMap>
					</ea:datalabel>.<BR>
				<LI>
					Dniami wolnymi od pracy z tytułu rozkładu czasu pracy w przeciętnie pięciodniowym tygodniu pracy są wszystkie soboty; 
                    za dni świąteczne przypadające w soboty pracodawca wyznaczy inny dzień wolny od pracy w tym samym okresie rozliczeniowym.
					<BR>
				<LI>
					Termin wypłaty wynagrodzenia za pracę
					<BR>
					– wynagrodzenie wypłaca się z dołu, niezwłocznie po ustaleniu jego pełnej 
					wysokości, nie później jednak niż w ciągu pierwszych 10 dni następnego miesiąca 
					kalendarzowego.<BR>
				<LI>
					Informacja o urlopie wypoczynkowym<br />
                    <ea:Section ID="sectionUrlop" runat="server">
                    Wymiar urlopu uwzględniający wykształcenie oraz poprzednie okresy zatrudnienia wynosi
					<ea:datalabel id="dlLimit" runat="server"></ea:datalabel> dni. W bieżącym roku przysługuje <ea:datalabel id="dlGodzProp" runat="server"></ea:DataLabel>
                    godzin (<ea:datalabel id="dlLimitProp" runat="server"></ea:datalabel> dni) urlopu - proporcjonalnie do przepracowanego okresu. 
                    </ea:Section>
                    <ea:Section ID="sectionUzupełniający" runat="server">
                        Wymiar urlopu uwzględniający wykształcenie oraz poprzednie okresy zatrudnienia 
                        wynosi <font face="Tahoma" size="2">
                        <ea:DataLabel ID="dlLimitBase" runat="server">
                        </ea:DataLabel>
                        </font> dni. Z dniem <font face="Tahoma" size="2">
                        <ea:DataLabel ID="dlDataUzup" runat="server">
                        </ea:DataLabel>
                        </font> pracownik nabędzie prawo do <font face="Tahoma" size="2">
                        <ea:DataLabel ID="dlLimitUzup" runat="server">
                        </ea:DataLabel>
                        </font> dni urlopu uzupełniającego. W bieżącym roku przysługuje
                        <font face="Tahoma" size="2">
                        <ea:DataLabel ID="dlGodzPropBase" runat="server">
                        </ea:DataLabel>
                        </font> godzin (<font face="Tahoma" size="2"><ea:DataLabel ID="dlLimitPropBase" 
                            runat="server">
                        </ea:DataLabel>
                        </font> dni) urlopu - proporcjonalnie do przepracowanego okresu oraz
                        <font face="Tahoma" size="2">
                        <ea:DataLabel ID="dlGodzPropUzup" runat="server">
                        </ea:DataLabel>
                        </font> godzin (<font face="Tahoma" size="2"><ea:DataLabel ID="dlLimitPropUzup" 
                            runat="server">
                        </ea:DataLabel>
                        </font> dni) urlopu uzupełniającego.</ea:Section>
                    <br>Urlop jest udzielany
                    w dni, które są dniami pracy zgodnie z obowiązującym rozkładem czasu pracy w danym
                    dniu.<br>
					Urlop na żądanie wymaga zgłoszenia bezpośredniemu przełożonemu przed jego 
					rozpoczęciem.<BR>
                    <ea:Section ID="Section2" runat="server" Width="100%">
                        Wymiar urlopu dodatkowego wynosi
                        <ea:datalabel id="dlLimitDod" runat="server"></ea:datalabel>
                        dni. W bieżącym roku przysługuje
                        <ea:datalabel id="dlGodzPropDod" runat="server"></ea:DataLabel>
                        godzin (
                        <ea:datalabel id="dlLimitPropDod" runat="server"></ea:datalabel>
                        dni) urlopu dodatkowego - proporcjonalnie do przepracowanego okresu.</ea:Section>
				<LI>
					Okres wypowiedzenia
					<ea:datalabel id="dlWypowiedzenie" runat="server" Bold="false">
						<ValuesMap>
							<ea:ValuesPair Key="1" Value="miesiąc"></ea:ValuesPair>
							<ea:ValuesPair Key="10" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="11" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="12" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="2" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="3" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="4" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="5" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="6" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="7" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="8" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="9" Value="miesięcy"></ea:ValuesPair>
						</ValuesMap>
					</ea:datalabel>.<BR>
				<LI>
					Pora nocna obejmuje
					<ea:datalabel id="dlNocneLimit" runat="server">
						<ValuesMap>
							<ea:ValuesPair Key="1" Value="miesiąc"></ea:ValuesPair>
							<ea:ValuesPair Key="10" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="11" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="12" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="2" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="3" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="4" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="5" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="6" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="7" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="8" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="9" Value="miesięcy"></ea:ValuesPair>
						</ValuesMap>
					</ea:datalabel>&nbsp;godzin pomiędzy godzinami
					<ea:datalabel id="dlNocneOd" runat="server">
						<ValuesMap>
							<ea:ValuesPair Key="1" Value="miesiąc"></ea:ValuesPair>
							<ea:ValuesPair Key="10" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="11" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="12" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="2" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="3" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="4" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="5" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="6" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="7" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="8" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="9" Value="miesięcy"></ea:ValuesPair>
						</ValuesMap>
					</ea:datalabel>&nbsp;a
					<ea:datalabel id="dlNocneDo" runat="server">
						<ValuesMap>
							<ea:ValuesPair Key="1" Value="miesiąc"></ea:ValuesPair>
							<ea:ValuesPair Key="10" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="11" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="12" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="2" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="3" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="4" Value="miesiące"></ea:ValuesPair>
							<ea:ValuesPair Key="5" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="6" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="7" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="8" Value="miesięcy"></ea:ValuesPair>
							<ea:ValuesPair Key="9" Value="miesięcy"></ea:ValuesPair>
						</ValuesMap>
					</ea:datalabel>.
				<BR/>
                    <ea:Section ID="Section1" runat="server" Width="100%">
                    <li>Jest <ea:datalabel id="Datalabel9" runat="server" Bold="False" DataMember="Plec">
                        <ValuesMap>
                            <ea:ValuesPair Key="Kobieta" Value="Pani objęta" />
                            <ea:ValuesPair Key="Mężczyzna" Value="Pan objęty" />
                        </ValuesMap>
                    </ea:DataLabel>
                        zakładowym układem zbiorowym pracy, który został zawarty
                        <ea:datalabel id="dlUkładZbiorowy" runat="server">
                        </ea:DataLabel>
                        .<BR/>
                    </ea:Section>
            </OL>
            <p>
            </p>
			<P>Podstawa prawna – art. 29 k.p.</P>
			<P><cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
					<Subtitles>
						<cc1:FooterSubtitle Caption="Data i podpis pracownika" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Podpis pracodawcy" Width="50"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:reportfooter></P>
                <p>
                </p>
                <p>
                </p>
            </p>
        	</font>
            <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
	        </ea:DataRepeater>
		</form>
	</body>
</HTML>
